/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "RpcRemoteException.h"

#include <cstdint>
#include <msgpack.hpp>
#include <optional>
#include <vector>

class RpcClientEvent
{
private:
	std::int32_t EventID;
	std::vector<msgpack::object> Args;
	std::optional<RpcRemoteException> Error;

public:
	std::int32_t GetEventID() const { return EventID; }
	const std::vector<msgpack::object>& GetArgs() const { return Args; }

	std::vector<msgpack::object>& GetArgs() { return Args; }

	RpcRemoteException GetError() const
	{
		if (Error.has_value())
			return Error.value();
		throw std::runtime_error("No exception!");
	}
	bool HasError() const { return Error.has_value(); }

	RpcClientEvent()
	{
		EventID = -1;
		Error = {};
	}
	RpcClientEvent(std::int32_t eventID)
	{
		EventID = eventID;
		Error = {};
	}
	RpcClientEvent(const RpcRemoteException& e)
	{
		EventID = -1;
		Error = e;
	}
};
